/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.AttendanceHolidayCardVo;

public class AttendanceHolidayCardAction extends AttendanceTotalAction {

	// R}h
	public static final String CMD_HOLIDAY_CARD_SHOW		= "K1130";
	public static final String CMD_HOLIDAY_CARD_SELECT	= "K1131";
	private static final String CMD_HOLIDAY_CARD_REGIST	= "K1132";
	private static final String CMD_HOLIDAY_CARD_DELETE	= "K1133";

	/**
	 * RXgN^
	 */
	public AttendanceHolidayCardAction() {
		super();
	}

	public void action() throws Exception {
		// VO̎擾
		AttendanceHolidayCardVo vo;
		vo = (AttendanceHolidayCardVo)getStoredVo(CommonConst.VO_ATTENDANCE_HOLIDAY_CARD);
		if (vo == null) {
			vo = new AttendanceHolidayCardVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_ATTENDANCE_HOLIDAY_CARD, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		MSyukkinboDto dto;
		Object objDto = session.getAttribute(MospConst.ATT_DTO);
		dto = objDto instanceof MSyukkinboDto ? (MSyukkinboDto)objDto : null;
		// DBRlNV擾
		getConnection();
		// [U[擾
		getInfo(user.getUserId());
		// [Nv_E
		vo.aryPltSubstituteYear = util.getYearArray(MospUtility.getYear (util.getSystemDate()), 1, 2);
		// [v_E
		vo.aryPltSubstituteMonth = util.getMonthArray();
		// [v_E
		vo.aryPltSubstituteDay = util.getDayArray();
		// xɗRv_E
		vo.aryPltHolidayReason = getReasonCodeArray(CommonConst.TID_LEAVE_REASON);
		// xɏؖv_E
		vo.aryPltHolidayCertificate = getMosPCodeArray(CommonConst.TID_HOLIDAY_CERTIFICATE);
		// ΑӊǗR}h
		setSubTitleMenu(vo);
		// R}h̏
		if (cmd.equals(CMD_HOLIDAY_CARD_SHOW)) {
			// \ڂ̏
			vo.initFields();
			// \̏
			setAttendanceInfo(vo);
			// \{^͏o
			// o΃{^ɃR}hZbg
			vo.setCmdStartButton(AttendanceStartCardAction.CMD_START_CARD_SHOW);
			// \[hZbg
			setMode(vo, dto);
		} else if (cmd.equals(CMD_HOLIDAY_CARD_SELECT)) {
			// \̏
			setAttendanceInfo(vo);
			// xɌ
			dto = searchHoliday(vo);
			// xɃ{^ɃR}hZbg
			vo.setCmdHolidayButton(CMD_HOLIDAY_CARD_SELECT);		
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_HOLIDAY_CARD_REGIST)) {
			vo.setParams(request);
			// o^
			dto = registHoliday(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
			// Αӈꗗ֑J
			setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			// bZ[Wݒ
			request.setAttribute(MospConst.ATT_MESSAGE, MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		} else if (cmd.equals(CMD_HOLIDAY_CARD_DELETE)) {
			vo.setParams(request);
			// 폜
			dto = delete(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
			// Αӈꗗ֑J
			setNextCmd(AttendanceListAction.CMD_ATTENDANCE_LIST_RE_SEARCH);
			// bZ[Wݒ
			request.setAttribute(MospConst.ATT_MESSAGE, MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));			
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
		// ČpMenuVo̕ۑ
		setStoreAttendanceMenuVo(vo);
	}

	/**
	 * xɌ
	 * @param vo AttendanceCardVoCX^X
	 * @return 擾AttendanceCardDtoCX^X
	 * @throws Exception
	 */
	private MSyukkinboDto searchHoliday(AttendanceHolidayCardVo vo) throws Exception {
		// Αӌ
		MSyukkinboDto dto = getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate());
		// VOɏݒ
		vo.setFields(dto);
		// \[h̃Zbg
		setMode(vo, dto);
		return dto;
	}

	/**
	 * xɓo^
	 * @param vo  VoCX^X
	 * @param dto DtoCX^X
	 * @return o^Ď擾DtoCX^X
	 * @throws Exception
	 */
	private MSyukkinboDto registHoliday(
			AttendanceHolidayCardVo vo,
			MSyukkinboDto dto
	) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// oΕpDAO 
		prepareMSyukkinboDao();
		// Αӌ
		MSyukkinboDto mSyukkinboDto = new MSyukkinboDto();
		if (dto == null) {
			// INSERT(ZbVۑDTO݂Ȃꍇ)
			// vZ
			runAutoHolidayCalc(vo);
			vo.setDtoFields(mSyukkinboDto);
			mSyukkinboDto.setSyozoku(mKihon.getSCode());
			// ݃`FbN
			chkDuplicate(getSyukkinboInfo(mSyukkinboDto.getKCode(), mSyukkinboDto.getHizuke()), vo);
			// o^ixɍڂ̂݁j			
			syukkinboDao.insertHoliday(mSyukkinboDto);
		} else {
			// Fς݂̏ꍇ̓bZ[W\Ao^s
			if (isApproved(dto)) {
				// bZ[Wݒ
				request.setAttribute(MospConst.ATT_MESSAGE, 
						MospUtility.getMessage(msg, CommonConst.MSG_ALREADY_APPROVED, 
								getMessageDate(vo.getHidYear(), vo.getHidMonth(), vo.getHidDay())
						)
				);
			} else {
				// UPDATE(ZbVۑDTO݂ꍇ)
				mSyukkinboDto = dto;
				// rmF
				chkExclusive(mSyukkinboDto, getSyukkinboInfo(mSyukkinboDto.getKCode(), mSyukkinboDto.getHizuke(), true), vo);
				// vZ
				runAutoHolidayCalc(vo);
				vo.setDtoFields(mSyukkinboDto);
				// XVixɍڂ̂݁j
				syukkinboDao.updateHoliday(mSyukkinboDto);
			}
		}
		// DTO̍Ď擾
		MSyukkinboDto retDto = getSyukkinboInfo(mSyukkinboDto.getKCode(), mSyukkinboDto.getHizuke());
		chkUpdate(retDto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * xɍڍ폜
	 * @param dto
	 * @throws Exception
	 */
	private MSyukkinboDto delete(AttendanceHolidayCardVo vo, MSyukkinboDto dto) throws Exception {
		// oΕpDAO 
		prepareMSyukkinboDao();
		// f[^݊mF
		chkExist(dto);
		// Fς݂̏ꍇ̓bZ[W\A폜s
		if (isApproved(dto)) {
			// bZ[Wݒ
			request.setAttribute(MospConst.ATT_MESSAGE, 
					MospUtility.getMessage(msg, CommonConst.MSG_ALREADY_APPROVED, 
							getMessageDate(vo.getHidYear(), vo.getHidMonth(), vo.getHidDay()))
			);
		} else {
			// 폜
			syukkinboDao.delete(dto);
		}
		// DTO̍Ď擾
		MSyukkinboDto retDto = getSyukkinboInfo(dto.getKCode(), dto.getHizuke());
		// R~bg
		commit();
		return retDto;
	}

	/**
	 * vZ\bh
	 * @param vo
	 * @throws Exception
	 */
	private void runAutoHolidayCalc(AttendanceHolidayCardVo vo) throws Exception {
		// Ώۓ擾
		Date targetDay = util.convStringDateToDate(vo.getHidDate());
		// Αӓf[^擾
		getAttendanceDay(vo.getHidKCode(), targetDay);
		// vZtOL̂
		if (isAutoCalc) {
			// SxxɎ
			vo.setHolidayTimes(allHoliday);
		}
	}

}
